<?php
class Profit extends controller
{
    private $A_data = array();
    private $B_data = array();

    public function sponsor($id)
    {
        $sponsor = $this->DB->dbFetchColumn("SELECT P.sponsor FROM member AS T LEFT JOIN(package AS P) ON (T.package_id=P.package_id) WHERE T.uid=? ", [$id]);

        try {
            $qry = $this->DB->dbFetchAll("SELECT M.uid, M.name, M.account_type, M.bba_address, P.package, DATE_FORMAT(M.registration_date, '%d-%m-%Y %H:%i') AS join_date, CONCAT('$',(P.usd*$sponsor)) AS bonus FROM member AS M JOIN(package AS P) ON (M.package_id=P.package_id) WHERE M.sponsor_id=? ORDER BY M.registration_date ASC", [$id]);
            echo json_encode($qry);
        } catch (PDOException $e) {
            echo $e->getMessage();
        }
    }

    private function sponsorByDate($id)
    {
        try {
            $data = [];
            $sponsor = $this->DB->dbFetchColumn("SELECT P.sponsor FROM member AS T LEFT JOIN(package AS P) ON (T.package_id=P.package_id) WHERE T.uid=? ", [$id]);


            $qry = $this->DB->dbFetchAll("SELECT DATE(M.registration_date) AS join_date, (P.usd*$sponsor) AS bonus FROM member AS M JOIN(package AS P) ON (M.package_id=P.package_id) WHERE M.sponsor_id=? ORDER BY M.registration_date ASC", [$id]);
            foreach ($qry as $val) {
                $data[$val['join_date']] += $val['bonus'];
            }

            return $data;
        } catch (PDOException $e) {
            echo $e->getMessage();
        }
    }

    //-------------------------------------- pairing -------------------------------------
    private function getChild($pid, $foot = 'Left', $level, $maxlevel)
    {
        $qry = $this->DB->dbQuery("SELECT M.uid, DATE(M.registration_date) AS REG, P.usd, P.pair_usd FROM member AS M LEFT JOIN(package AS P)ON(M.package_id=P.package_id) WHERE M.upline_id=? ORDER BY M.registration_date ASC", [$pid]);
        if ($this->DB->dbQNumRow($qry)) {
            while ($obj = $this->DB->dbFetchObject($qry)) {
                $reg = explode("-", $obj->REG);
                $d = mktime(0, 0, 0, $reg[1], $reg[2], $reg[0]);

                if ($foot == 'Left') {
                    if (isset($this->A_data[$d])) $this->A_data[$d] += 1;
                    else $this->A_data[$d] = 1;
                } else {
                    if (isset($this->B_data[$d])) $this->B_data[$d] += 1;
                    else $this->B_data[$d] = 1;
                }

                if ($level < $maxlevel)
                    $this->getChild($obj->uid, $foot, $level + 1, $maxlevel);
            }
        }
    }

    private function getNode($pid, $max)
    {
        $level = 1;
        $qry = $this->DB->dbQuery("SELECT M.uid, M.foot, DATE(M.registration_date) AS REG, P.usd, P.pair_usd FROM member AS M LEFT JOIN(package AS P)ON(M.package_id=P.package_id) WHERE M.upline_id=? ORDER BY M.registration_date ASC", [$pid]);
        if ($this->DB->dbQNumRow($qry)) {
            while ($obj = $this->DB->dbFetchObject($qry)) {
                $reg = $obj->REG;
                $reg = explode("-", $obj->REG);
                $d = mktime(0, 0, 0, $reg[1], $reg[2], $reg[0]);

                if ($obj->foot == 'Left') {
                    if (isset($this->A_data[$d])) $this->A_data[$d] += 1;
                    else $this->A_data[$d] = 1;
                } else if ($obj->foot == 'Right') {
                    if (isset($this->B_data[$d])) $this->B_data[$d] += 1;
                    else $this->B_data[$d] = 1;
                }
                $this->getChild($obj->uid, $obj->foot, $level++, $max);
            }
        }
    }

    private function getpairing($id)
    {
        $obj = $this->DB->dbFetchObject("SELECT M.uid, DATE(M.registration_date) AS REG, P.pair_level, P.pair_usd,P.max_pair FROM member AS M LEFT JOIN(package AS P)ON(M.package_id=P.package_id) WHERE M.uid=?", [$id]);

        if ($obj) {
            $max = $obj->max_pair;
            $usd = $obj->pair_usd;
            $pairUsd = $obj->pair_usd;

            $reg = explode("-", $obj->REG);
            $day = mktime(0, 0, 0, $reg[1], $reg[2], $reg[0]);
            $this->getNode($id, $max);
            ksort($this->A_data);
            ksort($this->B_data);

            $curdate = mktime(0, 0, 0, date("m"), date("d"), date("Y"));
            $no = 1;
            $pair = $left = $right = $remain_left = $remain_right = 0;
            $state = "";

            $data = [];
            while ($day <= $curdate) {
                $date = date("Y-m-d", $day);
                $d = $day;

                if (array_key_exists($d, $this->A_data)) {
                    $left += $this->A_data[$d];
                }
                if (array_key_exists($d, $this->B_data)) {
                    $right += $this->B_data[$d];
                }

                if ($left && $right) {
                    $leftMax = $left; //*$pairUsd;                    
                    $rightMax = $right; //*$pairUsd;                    

                    if (($leftMax >= $max) && ($rightMax >= $max)) {
                        $pair = $max;
                        $remain_left = $remain_right = 0;
                        $remains  = 'Flush Out';
                    } else {
                        if ($left > $right) {
                            $pair = $right;
                            $remain_left = $left - $pair;
                            $remain_right = 0;
                            $remains = "Left : " . $remain_left;
                        } else if (($left < $right)) {
                            $pair = $left;
                            $remain_right = ($right - $pair);
                            $remain_left = 0;
                            $remains = "Right : " . $remain_right;
                        }
                    }
                    $bonus = ($pair * $pairUsd);
                    //if($bonus>=$max) $bonus=$max;
                    $bonus = number_format($bonus, 2);

                    //echo "<tr><td>$no</td><td>$date</td><td>$left</td><td>$right</td><td>$pair</td><td style='text-align:right; color:#888; font-style:italic'>$remains $state</td><td align=right>$bonus</td></tr>";

                    $data[] = ['date' => $date, 'left' => $left, 'right' => $right, 'pair' => $pair, 'status' => $remains, 'bonus' => '$' . $bonus, 'usd' => $bonus];

                    $left = $remain_left;
                    $right = $remain_right;
                    $no++;
                    $pair = '';
                }
                $day = mktime(0, 0, 0, date("n", $d), (date("j", $d) + 1), date("Y", $d));
            }
        }

        return $data;
    }

    public function pairing($id)
    {
        $data = $this->getpairing($id);

        echo json_encode($data);
    }

    /*------------------------------- Matching ROI -------------------------------*/
    private function getROI($id, $level)
    {
        $data = [];

        $passive = $this->DB->dbFetchColumn("SELECT P.passive FROM member AS T JOIN (package AS P) ON (T.package_id=P.package_id) WHERE T.uid=?", [$id]);

        $matchLevel = [
            '1' => (0.3 * $passive),
            '2' => (0.2 * $passive),
            '3' => (0.1 * $passive),
            '4' => (0.05 * $passive),
            '5' => (0.05 * $passive),
            '6' => (0.05 * $passive)
        ];

        $i = 1;
        $totusd = 0;

        try {
            $qry = $this->DB->dbQuery("SELECT T.uid, DATE(T.registration_date) AS reg, P.usd FROM member AS T JOIN (package AS P) ON (T.package_id=P.package_id) WHERE T.sponsor_id=? ORDER BY registration_date", [$id]);
            while ($obj = $this->DB->dbFetchObject($qry)) {
                $tmp = $this->getROI($obj->uid, ($level + 1));

                $reg = explode("-", $obj->reg);
                $day = mktime(0, 0, 0, $reg[1], $reg[2], $reg[0]);

                if ($tmp) {
                    $data = $tmp;
                }

                if (!isset($data[$day]['level-' . $level])) {
                    $i = 1;
                }
                $totusd += $matchLevel[$level];
                $data[$day]['level-' . $level] = ['level' => $level, 'totusd' => ($totusd), 'tot' => $i];

                $i++;
            }
        } catch (PDOException $e) {
            echo $e->getMessage();
            return;
        }

        return $data;
    }

    private function _roi($id)
    {
        $data = $this->getROI($id, 1);

        ksort($data);
        $profit = [];

        foreach ($data as $key => $val) {
            foreach ($val as $valResult) {
                $level = $valResult['level'];
                $totusd = $valResult['totusd'];
                $tot = $valResult['tot'];

                $profit[] = ['date' => date('Y-m-d', $key), 'level' => $level, 'tot' => $tot, 'bonus' => '$' . $totusd, 'usd' => $totusd];
            }
        }

        return ($profit);
    }

    public function roi($id)
    {
        $data = $this->_roi($id);

        echo json_encode($data);
    }

    /*------------------------------- Earning -------------------------------*/
    public function earning($id)
    {
        $sponsor = $this->sponsorByDate($id);

        //pairing
        $dataPairing = $this->getpairing($id);
        $pairing = [];
        foreach ($dataPairing as $item) {
            $date = $item['date'];
            if (!isset($pairing[$date])) {
                $pairing[$date] = 0;
            }
            $pairing[$date] += $item['usd'];
        }

        //roi
        $dataRoi = $this->_roi($id);
        $roi = [];
        foreach ($dataRoi as $item) {
            $date = $item['date'];
            if (!isset($roi[$date])) {
                $roi[$date] = 0;
            }
            $roi[$date] += $item['usd'];
        }

        $obj = $this->DB->dbFetchObject("SELECT DATE(T.registration_date) AS reg, P.usd FROM member AS T JOIN (package AS P) ON (T.package_id=P.package_id) WHERE T.uid=?", [$id]);

        $reg= $obj->reg;
        $start = new DateTime($reg);
        $now = (new DateTime('now'))->getTimestamp();

        $i = 1;
        $day = [];
        $data = [];
        $passive = ($obj->usd * 0.5)/100;

        while ($start->getTimestamp() <= $now) {

            $bonusSponsor = $sponsor[$start->format("Y-m-d")] ?? 0;
            $bonusPairing = $pairing[$start->format("Y-m-d")] ?? 0;
            $bonusROI = $roi[$start->format("Y-m-d")] ?? 0;

            $bonus = $passive + $bonusSponsor + $bonusPairing + $bonusROI;
            $data[] = $bonus;
            $day[] = $i;

            $start->modify("+1 day");
            $i++;
        }
        echo json_encode(['day' => $day, 'data' => $data, 'roi' => $roi]);
    }
}
