<?php
class Withdraw extends controller
{
    public function status($status)
    {
        $data = $this->DB->dbFetchAll("SELECT T.*, M.name, M.account_type, DATE_FORMAT(T.withdraw_date, '%Y-%m-%d') AS withdraw_date, CONCAT('$',FORMAT(T.amount,2)) AS amount,  CONCAT('$',FORMAT(T.fee,2)) AS fee,  CONCAT('$',FORMAT(T.paid_amount,2)) AS paid_amount FROM withdraw AS T JOIN (member AS M) ON (T.bba_id=M.uid) WHERE T.wd_status=? ORDER BY T.withdraw_date ASC", [$status]);
        echo json_encode($data);
    }

    public function paid()
    {
        $id = $_POST['id'] ?? null;

        try {
            $this->DB->dbQuery("UPDATE withdraw SET wd_status=? WHERE id=?", ['paid', $id]);

            echo json_encode(['status' => true, 'message' => 'Paid success']);
        } catch (Exception $e) {
            echo json_encode(['status' => false, 'message' => $e->getMessage()]);
        }
    }

    public function reject()
    {
        $id = $_POST['id'] ?? null;
        try {
            $this->DB->dbQuery("DELETE FROM withdraw WHERE id=?", [$id]);

            echo json_encode(['status' => true, 'message' => 'Delete success']);
        } catch (Exception $e) {
            echo json_encode(['status' => false, 'message' => $e->getMessage()]);
        }
    }

    public function restore()
    {
        $id = $_POST['id'] ?? null;
        try {
            $this->DB->dbQuery("UPDATE withdraw SET wd_status=? WHERE id=?", ['request', $id]);

            echo json_encode(['status' => true, 'message' => 'Restore success']);
        } catch (Exception $e) {
            echo json_encode(['status' => false, 'message' => $e->getMessage()]);
        }
    }
}
