<?php
//namespace lib\database;
class db
{
    private $host, $user, $pwd, $driver, $dbName;
    private $conn;

    public function __construct($db = "")
    {
        global $CONFIG;

        $this->host = $CONFIG['HOST'];
        $this->user = $CONFIG['USER'];
        $this->pwd = $CONFIG['PWD'];
        $this->driver = $CONFIG['DRIVER'];

        $this->dbName = (!empty($db)) ? $db : $CONFIG['DBNAME'];
        $this->dbConnect();
    }

    public function dbFetchAllAssoc($sql)
    {
        if (is_string($sql)) {
            if ($this->conn) {
                $qry = $this->conn->prepare($sql);
                $qry->execute();

                $result = $qry->fetchAll(PDO::FETCH_ASSOC);
                return $result;
            }
        } else {
            return $sql->fetchAll(PDO::FETCH_ASSOC);
        }
    }

    private function dbConnect()
    {
        try {
            $dsn = "$this->driver:dbname=$this->dbName;host=$this->host";
            $this->conn = new PDO($dsn, $this->user, $this->pwd);
            $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            return $this->conn;
        } catch (PDOException $e) {
            echo 'Connection failed: ' . $e->getMessage();
        }
    }

    public function connect($driver, $host, $db, $user, $pwd)
    {
        try {
            $dsn = "$driver:dbname=$db;host=$host";
            $conn = new PDO($dsn, $user, $pwd);
            $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            return $conn;
        } catch (PDOException $e) {
            echo 'Connection failed: ' . $e->getMessage();
        }
    }

    public function dbQuery($sql, $params = [])
    {
        $qry = $this->conn->prepare($sql);
        $qry->execute($params);

        return $qry;
    }

    public function dbFetchRow($sql)
    {
        if (is_string($sql)) {
            if ($this->conn) {
                $qry = $this->conn->prepare($sql);
                $qry->execute();

                $result = $qry->fetch(PDO::FETCH_NUM);
                return $result;
            }
        } else {
            return $sql->fetch(PDO::FETCH_NUM);
        }
    }

    public function dbFetchArray($sql, $params = [])
    {
        if (is_string($sql)) {
            $qry = $this->conn->prepare($sql);
            $qry->execute($params);
            return $qry->fetch(PDO::FETCH_BOTH);
        } else {
            return $sql->fetch(PDO::FETCH_BOTH);
        }
    }

    public function dbFetchObject($sql, $params = [])
    {
        if (is_string($sql)) {
            $qry = $this->conn->prepare($sql);
            $qry->execute($params);
            return $qry->fetch(PDO::FETCH_OBJ);
        } else {
            return $sql->fetch(PDO::FETCH_OBJ);
        }
    }

    public function dbFetchAssoc($sql, $params = [])
    {
        if (is_string($sql)) {
            $qry = $this->conn->prepare($sql);
            $qry->execute($params);
            return $qry->fetch(PDO::FETCH_ASSOC);
        } else
            return $sql->fetch(PDO::FETCH_ASSOC);
    }

    public function lastID()
    {
        return $this->conn->lastInsertId();
    }

    public function dbFetchColumn($sql, $params = [])
    {
        if (is_string($sql)) {
            $qry = $this->conn->prepare($sql);
            $qry->execute($params);
            return $qry->fetchColumn();
        } else {
            return $sql->fetchColumn();
        }
    }

    public function dbFetchAll($sql, $params = [])
    {
        if (is_string($sql)) {
            $qry = $this->conn->prepare($sql);
            $qry->execute($params);
            return $qry->fetchAll(PDO::FETCH_ASSOC);
        } else {
            return $sql->fetchAll(PDO::FETCH_ASSOC);
        }
    }

    public function dbQNumRow($qry)
    {
        return $qry->rowCount();
    }

    public function __destruct()
    {
        $this->conn = null;
        $CONFIG['DBHANDLE'] = null;
    }
}
